﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;

class MoneyServer
{
    static void Main()
    {
        const int StreamSize = 256;
        const int Port = 2010;

        var ipAddr = new IPAddress(
            new byte[] { 127, 0, 0, 1 });

        var talk = new List<string>
        {
"A penny saved is too small, make it a buck.",
"Keep your wooden nickel. It'll be worth something someday.",
"It's your dime, but you're better off dialing 10-10-XXX."
       };

        var mSvr = new MoneyServer();
        var AsciiEnc = new ASCIIEncoding();
        var inStream = new byte[StreamSize];
        var outStream = new byte[StreamSize];

        Random rnd = null;
        string reqString = string.Empty;
        int index = 0;

        var tcpl = new TcpListener(ipAddr, Port);

        tcpl.Start();

        Console.WriteLine("Server is Running...");

        do
        {
            try
            {
                Socket sock = tcpl.AcceptSocket();

                int count = sock.Receive(
                    inStream, inStream.Length, 0);
                reqString = AsciiEnc.GetString(
                    inStream, 0, count);

                Console.WriteLine(reqString);

                rnd = new Random();
                index = rnd.Next(talk.Count);

                outStream = AsciiEnc.GetBytes(
                    talk[index] as string);

                sock.Send(outStream, outStream.Length, 0);
            }
            catch (SocketException sockEx)
            {
                Console.WriteLine(
                "Generic Exception Message: {0}", 
                sockEx.ToString());
            }

        } while (reqString != "bye");

        tcpl.Stop();
    }
}
